/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.taxud.cesop.readers;

import eu.europa.ec.taxud.cesop.domain.MessageTypeEnum;
import eu.europa.ec.taxud.cesop.domain.MessageTypeIndicEnum;
import eu.europa.ec.taxud.cesop.domain.PaymentDataMsgPartContentType;
import eu.europa.ec.taxud.cesop.domain.XmlMessageSpec;
import eu.europa.ec.taxud.cesop.domain.XmlPaymentDataMsgPart;
import eu.europa.ec.taxud.cesop.domain.XmlPsp;
import eu.europa.ec.taxud.cesop.domain.XmlReportedPayee;
import eu.europa.ec.taxud.cesop.domain.XmlReportedTransaction;
import eu.europa.ec.taxud.cesop.readers.CesopParsingException;
import eu.europa.ec.taxud.cesop.readers.CesopXmlReader;
import eu.europa.ec.taxud.cesop.readers.IPspXmlReader;
import eu.europa.ec.taxud.cesop.readers.ReportedPayeeXmlReader;
import eu.europa.ec.taxud.cesop.readers.ReportedTransactionXmlReader;
import eu.europa.ec.taxud.cesop.readers.UnknownXsdVersionException;
import eu.europa.ec.taxud.cesop.readers.XmlStreamReaderWrapper;
import eu.europa.ec.taxud.cesop.utils.ValidationConstants;
import eu.europa.ec.taxud.cesop.utils.ValidationErrorUtils;
import eu.europa.ec.taxud.cesop.xsd.XsdSchema;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.format.DateTimeParseException;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.validation.XMLValidationSchema;

public class PspXmlReader
implements IPspXmlReader {
    private final int maxTransactionsInPart;
    private final XmlMessageSpec xmlMessageSpec;
    private final XmlPsp xmlReportingPsp;
    private final long estimatedContentLength;
    private final CesopXmlReader xmlReader;
    private XmlPaymentDataMsgPart paymentDataMsgPart;
    private ReportedPayeeXmlReader reportedPayeeXmlReader;
    private long partNumber;
    private boolean emptyTransactionsCurrentPayee = true;
    private boolean moveCursorToNextReportedPayee = true;

    public PspXmlReader(InputStream inputStream, long estimatedSize, int maxTransactionsInPart, boolean validateXsd) throws XMLStreamException {
        BufferedInputStream buffer = new BufferedInputStream(inputStream);
        this.xmlReader = new CesopXmlReader(buffer, validateXsd ? PspXmlReader.lookupXsd(buffer) : null);
        this.estimatedContentLength = estimatedSize;
        this.maxTransactionsInPart = maxTransactionsInPart;
        this.xmlMessageSpec = this.initXmlMessageSpec();
        this.xmlReportingPsp = this.xmlReader.positionCursorOnStartElement(ValidationConstants.XML.PAYMENT_DATA_BODY_QNAME) ? this.parsePsp() : null;
    }

    private static XMLValidationSchema lookupXsd(BufferedInputStream inputStream) throws XMLStreamException {
        inputStream.mark(8192);
        XmlStreamReaderWrapper versionReader = new XmlStreamReaderWrapper(inputStream, null);
        if (!versionReader.goToNextStartElement(ValidationConstants.XML.CESOP_QNAME)) {
            throw UnknownXsdVersionException.unparsableVersion();
        }
        Map<String, String> attrs = versionReader.getAttributes();
        String version = attrs.get("version");
        if (version == null) {
            throw UnknownXsdVersionException.unparsableVersion();
        }
        try {
            inputStream.reset();
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
        try {
            DecimalFormat versionFormat = new DecimalFormat("0.00", DecimalFormatSymbols.getInstance(Locale.ROOT));
            versionFormat.setMinimumFractionDigits(2);
            versionFormat.setMaximumFractionDigits(40);
            version = versionFormat.format(new BigDecimal(version));
        }
        catch (NumberFormatException e) {
            throw UnknownXsdVersionException.unsupportedVersion(version);
        }
        XMLValidationSchema result = XsdSchema.VERSION_2_XSD.get(version);
        if (result == null) {
            throw UnknownXsdVersionException.unsupportedVersion(version);
        }
        return result;
    }

    @Override
    public long getEstimatedContentSize() {
        return this.estimatedContentLength;
    }

    private XmlMessageSpec initXmlMessageSpec() throws XMLStreamException {
        XmlMessageSpec messageSpecXML = new XmlMessageSpec();
        this.xmlReader.positionCursorOnStartElement(ValidationConstants.XML.CESOP_QNAME);
        Map<String, String> attrs = this.xmlReader.getXmlStreamReaderWrapper().getAttributes();
        messageSpecXML.setXsdVersion(attrs.get("version"));
        Map<String, String> transmittingCountryValues = this.xmlReader.readNextTagIntoMap(ValidationConstants.XML.TRANSMITTING_COUNTRY_QNAME);
        messageSpecXML.setTransmittingCountry(ValidationErrorUtils.convertGreece(transmittingCountryValues.get("/TransmittingCountry")));
        Map<String, String> messageTypeValues = this.xmlReader.readNextTagIntoMap(ValidationConstants.XML.MESSAGE_TYPE_QNAME);
        messageSpecXML.setMessageType(MessageTypeEnum.findByLabel(messageTypeValues.get("/MessageType")));
        Map<String, String> messageTypeIndicValues = this.xmlReader.readNextTagIntoMap(ValidationConstants.XML.MESSAGE_TYPE_INDIC_QNAME);
        messageSpecXML.setMessageTypeIndic(MessageTypeIndicEnum.valueOf(messageTypeIndicValues.get("/MessageTypeIndic")));
        Map<String, String> messageRefIdValues = this.xmlReader.readNextTagIntoMap(ValidationConstants.XML.MESSAGE_REF_ID_QNAME);
        messageSpecXML.setMessageRefId(messageRefIdValues.get("/MessageRefId"));
        Optional<Map<String, String>> correlationMessageRefIdValuesOpt = this.xmlReader.readNextTagIfEquals(ValidationConstants.XML.CORR_MESSAGE_REF_ID_QNAME);
        correlationMessageRefIdValuesOpt.ifPresent(correlationMessageRefIdValues -> messageSpecXML.setCorrMessageRefId((String)correlationMessageRefIdValues.get("/CorrMessageRefId")));
        if (this.xmlReader.positionCursorOnStartElement() && this.xmlReader.getStartElementName().equals(ValidationConstants.XML.SENDING_PSP_QNAME)) {
            messageSpecXML.setSendingPsp(this.parsePsp());
        }
        Map<String, String> quarterValues = this.xmlReader.readNextTagIntoMap(ValidationConstants.XML.QUARTER_QNAME);
        String periodQuarter = quarterValues.get("/Quarter");
        Map<String, String> yearValues = this.xmlReader.readNextTagIntoMap(ValidationConstants.XML.YEAR_QNAME);
        String periodYear = yearValues.get("/Year");
        messageSpecXML.setReportingPeriod(Integer.parseInt(periodYear + periodQuarter));
        Map<String, String> timestampValues = this.xmlReader.readNextTagIntoMap(ValidationConstants.XML.TIMESTAMP_QNAME);
        messageSpecXML.setTimestamp(timestampValues.get("/Timestamp"));
        try {
            ValidationErrorUtils.XML_DATE_TIME_FORMATTER.parse(messageSpecXML.getTimestamp());
        }
        catch (DateTimeParseException e) {
            throw new CesopParsingException("Error while reading the XML file: " + e.getMessage(), e);
        }
        return messageSpecXML;
    }

    private XmlPsp parsePsp() throws XMLStreamException {
        Optional<Map<String, String>> valuesMap;
        Map<String, String> reportingPspMap = this.xmlReader.readNextTagIntoMap(ValidationConstants.XML.PSP_ID_QNAME);
        String pspIdType = reportingPspMap.get("/PSPId@PSPIdType");
        String pspIdOther = reportingPspMap.get("/PSPId@PSPIdOther");
        String pspId = reportingPspMap.get("/PSPId");
        XmlPsp reportingPspXML = new XmlPsp(pspIdType, pspId, pspIdOther);
        while ((valuesMap = this.xmlReader.readNextTagIfEquals(ValidationConstants.XML.NAME_QNAME)).isPresent()) {
            String pspNameType = valuesMap.get().get("/Name@nameType");
            String pspNameOther = valuesMap.get().get("/Name@nameOther");
            String pspName = valuesMap.get().get("/Name");
            reportingPspXML.addName(pspNameType, pspName, pspNameOther);
        }
        return reportingPspXML;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.paymentDataMsgPart == null) {
                this.paymentDataMsgPart = this.createNextPaymentDataMsgPart();
            }
            return this.paymentDataMsgPart != null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CesopParsingException("Error while reading the XML file: " + e.getMessage(), e);
        }
    }

    @Override
    public XmlPaymentDataMsgPart next() {
        if (this.paymentDataMsgPart != null) {
            XmlPaymentDataMsgPart result = this.paymentDataMsgPart;
            this.paymentDataMsgPart = null;
            return result;
        }
        if (this.hasNext()) {
            return this.next();
        }
        throw new NoSuchElementException();
    }

    private XmlPaymentDataMsgPart createNextPaymentDataMsgPart() throws XMLStreamException {
        if (!this.moveCursorToNextReportedPayee) {
            this.moveCursorToNextReportedPayee = true;
            return this.createReportedPayeePart();
        }
        while (this.xmlReader.positionCursorOnStartElement()) {
            QName qName = this.xmlReader.getStartElementName();
            if (qName.equals(ValidationConstants.XML.REPORTED_PAYEE_QNAME)) {
                this.emptyTransactionsCurrentPayee = true;
                this.moveCursorToNextReportedPayee = true;
                this.initializeReportedPayeePart();
                continue;
            }
            if (qName.equals(ValidationConstants.XML.REPORTED_TRANSACTION_QNAME)) {
                this.emptyTransactionsCurrentPayee = false;
                return this.createReportedTransactionPart(false);
            }
            if (this.reportedPayeeXmlReader == null) continue;
            if (this.emptyTransactionsCurrentPayee) {
                this.moveCursorToNextReportedPayee = false;
                return this.createReportedTransactionPart(true);
            }
            return this.createReportedPayeePart();
        }
        return null;
    }

    private void initializeReportedPayeePart() throws XMLStreamException {
        this.partNumber = 1L;
        this.reportedPayeeXmlReader = new ReportedPayeeXmlReader(this.xmlReader);
        this.reportedPayeeXmlReader.parseFirstPart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlPaymentDataMsgPart createReportedPayeePart() throws XMLStreamException {
        try {
            this.reportedPayeeXmlReader.parseSecondPart();
            XmlReportedPayee xmlReportedPayee = this.reportedPayeeXmlReader.getXmlReportedPayee();
            XmlPaymentDataMsgPart paymentDataPart = new XmlPaymentDataMsgPart();
            paymentDataPart.setPartNumber(1L);
            paymentDataPart.setContentType(PaymentDataMsgPartContentType.REPORTED_PAYEE);
            paymentDataPart.setXmlReportedPayee(xmlReportedPayee);
            XmlPaymentDataMsgPart xmlPaymentDataMsgPart = paymentDataPart;
            return xmlPaymentDataMsgPart;
        }
        finally {
            this.reportedPayeeXmlReader = null;
        }
    }

    private XmlPaymentDataMsgPart createReportedTransactionPart(boolean emptyTransactions) throws XMLStreamException {
        XmlReportedPayee xmlReportedPayee = this.reportedPayeeXmlReader.getXmlReportedPayee();
        ReportedTransactionXmlReader reportedTransactionXmlReader = new ReportedTransactionXmlReader(this.xmlReader, xmlReportedPayee.getOtherPaymentMethods(), xmlReportedPayee.getOtherPspRoles());
        LinkedList<XmlReportedTransaction> xmlReportedTransactions = new LinkedList<XmlReportedTransaction>();
        if (!emptyTransactions) {
            for (int i = 0; i < this.maxTransactionsInPart; ++i) {
                XmlReportedTransaction xmlReportedTransaction = reportedTransactionXmlReader.parse();
                xmlReportedTransactions.add(xmlReportedTransaction);
                if (this.xmlReader.positionCursorOnStartElement() && this.xmlReader.getStartElementName().equals(ValidationConstants.XML.REPORTED_TRANSACTION_QNAME)) continue;
                this.xmlReader.getXmlStreamReaderWrapper().markAsPeek();
                break;
            }
        } else {
            this.xmlReader.getXmlStreamReaderWrapper().markAsPeek();
        }
        XmlPaymentDataMsgPart paymentDataPart = new XmlPaymentDataMsgPart();
        paymentDataPart.setPartNumber(++this.partNumber);
        paymentDataPart.setContentType(PaymentDataMsgPartContentType.REPORTED_TRANSACTIONS);
        paymentDataPart.setXmlReportedPayee(xmlReportedPayee);
        paymentDataPart.setXmlReportedTransactions(xmlReportedTransactions);
        return paymentDataPart;
    }

    @Override
    public XmlMessageSpec getXmlMessageSpec() {
        return this.xmlMessageSpec;
    }

    @Override
    public XmlPsp getXmlReportingPsp() {
        return this.xmlReportingPsp;
    }

    @Override
    public void close() throws Exception {
        this.xmlReader.close();
    }
}

